import Image from "next/image";
export default function BlogCard({ title, date, discription, img, slug }) {
  const Mslug = slug
    .toLowerCase() // Convert to lowercase
    .replace(/:/g, "") // Remove colons
    .replace(/[^a-z0-9\s-]/g, "") // Remove non-alphanumeric characters
    .trim() // Trim spaces at the start and end
    .replace(/\s+/g, "-");
  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 d-flex">
        <article className="d-flex">
          <div className="card border border-dark">
            <figure className="card-img-top m-0 overflow-hidden bsb-overlay-hover">
              <a href={`/blog/${Mslug}`}>
                <Image
                  style={{ height: "250px" }}
                  width={400}
                  height={400}
                  className="img-fluid bsb-scale bsb-hover-scale-up object-fit-cover w-100"
                  loading="lazy"
                  src={img}
                  alt=""
                />
              </a>
            </figure>
            <div className="card-body border-0 bg-white p-3">
              <div className="entry-header mb-3">
                <ul className="entry-meta list-unstyled d-flex mb-2">
                  <li>
                    <a
                      className="link-dark link-opacity-75 link-opacity-100-hover text-decoration-none"
                      href={`/blog/${Mslug}`}
                    >
                      <span className="fs-7">{date}</span>
                    </a>
                  </li>
                </ul>
                <h2
                  className="card-title entry-title h4 mb-0"
                  style={{ fontSize: "18px", lineHeight: "27px" }}
                >
                  <a
                    className="link-dark link-opacity-100 link-opacity-75-hover text-decoration-none"
                    href={`/blog/${Mslug}`}
                  >
                    {title}
                  </a>
                </h2>
              </div>
              <p
                className="card-text entry-summary text-secondary m-0 p-0"
                style={{ fontSize: "15px" }}
              >
                {discription}
              </p>
              <h4
                className="h6 text-black bsb-hover-fadeInRight mt-2"
                style={{ fontSize: "18px" }}
              >
                Read More..
              </h4>
            </div>
          </div>
        </article>
      </div>
    </>
  );
}
