export default function BlogSchema({ title, img, url, blogurl }) {
  const Json = {
    "@context": "https://schema.org",
    "@type": "Article",
    headline: title,
    image: img,
    author: {
      "@type": "Person",
      name: "Palm Jebel Ali",
    },
    publisher: {
      "@type": "Organization",
      name: "Palm Jebel Ali",
      logo: {
        "@type": "ImageObject",
        url: url,
      },
    },
    mainEntityOfPage: {
      "@type": "WebPage",
      "@id": blogurl,
    },
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
