// ModalContext.jsx
"use client";
import React, { createContext, useContext, useState } from "react";
import Form from "../components/Form";
import Modal from "../components/Modal";
import { domain } from "@/app/domain";
const ModalContext = createContext();
export const useModal = () => useContext(ModalContext);
export const ModalProvider = ({ children }) => {
  const [showModal, setShowModal] = useState(false);
  const [modalTitle, setModalTitle] = useState("");
  const [modalData, setModalData] = useState({});

  const toggleModal = (
    title,
    project_name,
    price,
    bedroom,
    size,
    community_name,
    type,
    developer
  ) => {
    setModalTitle(title);
    setModalData({
      project_name,
      price,
      bedroom,
      size,
      community_name,
      type,
      developer,
    });
    setShowModal((prev) => !prev);
  };

  return (
    <ModalContext.Provider value={{ toggleModal }}>
      {children}
      <Modal show={showModal} setShow={setShowModal} title={modalTitle}>
        <Form
          domain={domain}
          looking_for={modalTitle}
          modalData={modalData} // Spread the data to pass it as props
        />
      </Modal>
    </ModalContext.Provider>
  );
};
