"use client";
import { WhyInvest } from "@/data/data";
import React, { useState } from "react";
import { FiChevronDown, FiChevronUp } from "react-icons/fi";
const Faqs = () => {
  const [activeIndex, setActiveIndex] = useState(null);
  const handleToggle = (index) => {
    setActiveIndex(index === activeIndex ? null : index);
  };

  return (
    <section className="faq-section p-2">
      <div className="container">
        <h2 className="text-center">Frequently Asked Questions</h2>
        <div className="row mt-5">
          <div className="col-lg-12">
            {WhyInvest.map((items, index) => (
              <div
                key={index}
                className={`faq-item ${activeIndex === index ? "open" : ""}`}
              >
                <div className="faq-title" onClick={() => handleToggle(index)}>
                  {items.title}
                  {activeIndex === index ? (
                    <FiChevronUp className="icon" />
                  ) : (
                    <FiChevronDown className="icon" />
                  )}
                </div>
                <div
                  className={`faq-content ${
                    activeIndex === index ? "show" : ""
                  }`}
                >
                  {items?.description}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Faqs;
