"use client";
import { useModal } from "@/context/ModalContext";
export default function FloorPlan() {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="mb-0 pt-2 pb-0">
        <div className="container-fluid">
          <div className="container">
            <div className="row">
              <div className="col-lg-6">
                <img
                  src="/images/floor.webp"
                  className="conatin w-100 h-100 object-fit-cover mt-3"
                />
              </div>
              <div className="col-lg-6 d-flex align-items-center">
                <div>
                  <h2 className="mb-3">Palm Jebel Ali Floor Plan</h2>
                  <p>
                    Palm Jebel Ali Villas offer a variety of floor plans,
                    including 5, 6, and 7-bedroom villas and plots to cater to
                    different preferences. This luxury development features 16
                    categories of villas within the Beach and Coral collections,
                    each with its own unique and attractive design façade. From
                    the spacious 5 and 6-bedroom Beach Villas to the grand
                    7-bedroom Coral Villas, every design prioritizes seamless
                    indoor-outdoor living, maximizing sea views and ensuring a
                    timeless appeal.
                  </p>
                  <a onClick={() => toggleModal("Download Floor Plan")}>
                    <button className="webbutton mt-3">
                      Download Floor Plan
                    </button>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
