import BlogCard from "@/components/BlogCard";
import { blogdata } from "@/data/data";

export default async function HBlogSec() {
  const { cards } = await blogdata;
  return (
    <>
      <section className="py-3 py-md-5">
        <div className="container">
          <div className="row justify-content-md-center">
            <div className="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
              <h2 className="mb-2 display-5 text-center">Our Blogs</h2>
              <hr className="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle" />
            </div>
          </div>
        </div>
        <div className="container overflow-hidden">
          <div className="row gy-4 gy-xxl-5">
            {cards.slice(-3).map((items, index) => (
              <BlogCard
                title={items.title}
                discription={items.discription}
                img={items.img}
                date={items.date}
                slug={items.title}
                key={index}
              />
            ))}
          </div>
        </div>
      </section>
    </>
  );
}
