"use client";
import { FaArrowCircleRight } from "react-icons/fa";
import Form from "../components/Form";
import { useModal } from "@/context/ModalContext";
export default function Hero() {
  const { toggleModal } = useModal();
  return (
    <>
      <div className="GoldHero">
        <header>
          <div
            className="bg-image"
            style={{
              backgroundImage: `url(/images/bhariabac.jpg)`,
              height: 600,
            }}
          >
            <div
              className="mask h-100 w-100"
              style={{
                backgroundImage:
                  "linear-gradient(.528turn, #0000007a 60%, #0000)",
              }}
            >
              <div className="d-flex align-items-center h-100">
                <div className="container">
                  <div className="row">
                    <div className="text-white details col-lg-6 col-md-7">
                      <div>
                        <h1 className="mb-2 mt-3 main_heading">
                          Palm Jebel Ali
                        </h1>

                        <p>
                          Palm Jebel Ali, a stunning development by Nakheel
                          Properties as part of the Palm Islands project, is set
                          to transform luxury living in Dubai. This highly
                          anticipated community offers a unique and upscale
                          lifestyle. Conveniently located near Dubai Marina and
                          The Palm, it features luxurious villas, stylish
                          apartments, and a variety of property options to suit
                          different preferences Palm Jebel Ali aims to house
                          35,000 families and host 80 hotels on 7 interconnected
                          islands. This is part of Dubai Economic Agenda D33.
                        </p>
                        <div className="d-flex gap-2">
                          <div className="mt-3">
                            <a
                              onClick={() =>
                                toggleModal("Presale Consultation")
                              }
                            >
                              <button className="webbutton d-flex align-items-center gap-2">
                                Presale Consultation{" "}
                                <FaArrowCircleRight
                                  style={{ fontSize: "20px" }}
                                />
                              </button>
                            </a>
                          </div>
                          <div className="mt-3">
                            <a
                              onClick={() =>
                                toggleModal("List of exclusive offers")
                              }
                            >
                              <button className="webbutton bg-white text-black">
                                List of exclusive offers
                              </button>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div className="col-lg-4 col-md-5 offset-lg-2">
                      <div className="from rounded p-4 text-dark">
                        <h3 className="formcontent">
                          Book your free consultation
                        </h3>
                        <p>
                          Fill out the form for exclusive property details. Our
                          team will assist you in finding your perfect home!
                        </p>
                        <Form
                          looking_for="Book your free consultation"
                          modalData=""
                        />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </header>
      </div>
    </>
  );
}
