"use client";
import OffPlanCard from "@/components/OffPlanCard";
import { cardsdata } from "@/data/data";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, Navigation } from "swiper/modules";
const OffPlanCardsSec = () => {
  return (
    <>
      <section className="mainCards" id="Buy">
        <div className="SaleCards" id="New_Projects">
          <div className="container-fluid px-0">
            <h2 className="pb-4 text-center">Palm Jebel Ali Available Units</h2>
            <div className="sale-cards-container">
              <div className="container customContainer p-0">
                <Swiper
                  breakpoints={{
                    "@0.00": {
                      slidesPerView: 1,
                    },
                    "@0.75": {
                      slidesPerView: 1,
                    },
                    "@1.00": {
                      slidesPerView: 2,
                    },
                    "@1.50": {
                      slidesPerView: 3,
                    },
                  }}
                  slidesPerView={3}
                  autoplay={{
                    delay: 2500,
                    disableOnInteraction: false,
                  }}
                  pagination={{
                    clickable: true,
                  }}
                  navigation={true}
                  modules={[Autoplay, Navigation]}
                  className="mySwiper"
                >
                  {cardsdata.map((property, index) => (
                    <SwiperSlide key={index}>
                      <OffPlanCard
                        property_name={property?.property_name}
                        location={property?.community_name}
                        price={property?.starting_price}
                        para={property?.para}
                        img={property?.cover_image}
                        bedroom={property?.bedroom}
                        developer={property?.developer_name}
                        types={property?.types}
                        size={property?.size}
                      />
                    </SwiperSlide>
                  ))}
                </Swiper>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default OffPlanCardsSec;
